class PlayerStats expands Mutator config(XPlayerStatsDB);

// database config vars:
var config string SPlayer[10000];
var config int SFrags[10000];

// temp statistic vars, these will be xfered when game end.
var string TempPlayer[100];
var int TempFrags[100];
var bool bResetTempVars;
var bool bRunOnce;

var bool bTempDataMoved;

function PostBeginPlay()
{
        settimer(1.0, true);
}

function PreBeginPlay()
{
	InitStats();
	bTempDataMoved = False;
}

function Timer()
{
local Pawn P;
local int i,ii;
local int OnlinePlayers;

	//check if server becomes empty, then load data to DB

	OnlinePlayers = 0;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			OnlinePlayers++;
			}
		}
	if ( OnlinePlayers < 1 && !bTempDataMoved)
		{
		for ( i=0; i<100; i++ )
			{
			if ( TempPlayer[i] != "" )
				{
				for ( ii=0; ii<10000; ii++ )
					{
					if (( TempPlayer[i] == SPlayer[ii] ) || ( SPlayer[ii] == "" ))
						{
						SPlayer[ii] = TempPlayer[i];
						SFrags[ii] = TempFrags[i];
						TempPlayer[i] = "";
						TempFrags[i] = 0;
						ii = 20000;
						}
					}
				}
			}
		bTempDataMoved = True;
		SaveConfig();
		log("MHX - The last player left the server, so the data has been transfered to the database.");
		}
	else if ( OnlinePlayers > 0 )
		{
		bTempDataMoved = False;
		}

	GrabScoreFromDB();

}

function GrabScoreFromDB() 
{
local int i,ii;
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn') && P.Tag != 'Checked')
			{	
			for (ii=0;ii<10000;ii++)
				{
				if (P.PlayerReplicationInfo.PlayerName == SPlayer[ii] || SPlayer[ii] == "")
					{
					SPlayer[ii] = P.PlayerReplicationInfo.PlayerName;
					P.PlayerReplicationInfo.Score = SFrags[ii];
					P.Tag = 'Checked';
					//give weapon just for test:
					//DeathMatchPlus(Level.Game).GiveWeapon(P,"BotPack.minigun2");
					//DeathMatchPlus(Level.Game).GiveWeapon(P,"MHXv3.Weap_minigun2");
					ii=20000;
					}
				}
	
			}
		if (P.IsA('Bot') && P.Tag != 'Checked')
			{	
			for (ii=0;ii<10000;ii++)
				{
				if (P.PlayerReplicationInfo.PlayerName == SPlayer[ii] || SPlayer[ii] == "")
					{
					SPlayer[ii] = P.PlayerReplicationInfo.PlayerName;
					P.PlayerReplicationInfo.Score = SFrags[ii];
					P.Tag = 'Checked';
					ii=20000;
					}
				}
	
			}
		}
}

function InitStats()
{
local int i;

	if ( !bResetTempVars )
		{
		for ( i=0; i<100; i++ )
			{
			TempPlayer[i] = "";
			TempFrags[i] = 0;
			}
		bResetTempVars = True;
		log("MHX - The mutator is active and is now gathering runtime stats on the players.");
		}
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	CollectData();
}

function CollectData()
{
local Pawn P;
local int i;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn') || P.IsA('Bot'))
			{
			for ( i=0; i<100; i++ )
				{
				if (( P.PlayerReplicationInfo.PlayerName == TempPlayer[i] ) || ( TempPlayer[i] == "" ))
					{
					TempPlayer[i] = P.PlayerReplicationInfo.PlayerName;
					TempFrags[i] = P.PlayerReplicationInfo.Score;
					i = 200;
					}
				}
			}
		}
}

function HandleStats()
{
local Pawn P;
local int i,ii,a;



if ( !bRunOnce )
	{
	for (P = Level.PawnList; P != None; P = P.NextPawn)
	{
	if (P.IsA('Bot') || P.IsA('PlayerPawn'))
		{
		for ( i=0; i<100; i++ )
			{
			if (( P.PlayerReplicationInfo.PlayerName == TempPlayer[i] ) || ( TempPlayer[i] == "" ))
				{
				TempPlayer[i] = P.PlayerReplicationInfo.PlayerName;
				TempFrags[i] = P.PlayerReplicationInfo.Score;
				i = 200;
				}
			}
		}
	for ( i=0; i<100; i++ )
			{
			if ( TempPlayer[i] != "" )
				{
				for ( ii=0; ii<10000; ii++ )
					{
					if (( TempPlayer[i] == SPlayer[ii] ) || ( SPlayer[ii] == "" ))
						{
						SPlayer[ii] = TempPlayer[i];
						SFrags[ii] = TempFrags[i];
						TempPlayer[i] = "";
						TempFrags[i] = 0;
						ii = 20000;
						}
					}
				}
			}
	}
	bRunOnce = True;
	log("Statistics - The stats have been calculated and transfered to the database.");
	}	
}

function bool HandleEndGame()
{

	HandleStats();
	SaveConfig();

}

function NoPlayers()
{
local int i,ii;

	for ( i=0; i<100; i++ )
			{
			if ( TempPlayer[i] != "" )
				{
				for ( ii=0; ii<10000; ii++ )
					{
					if (( TempPlayer[i] == SPlayer[ii] ) || ( SPlayer[ii] == "" ))
						{
						SPlayer[ii] = TempPlayer[i];
						SFrags[ii] = TempFrags[i];
						TempPlayer[i] = "";
						TempFrags[i] = 0;
						ii = 20000;
						}
					}
				}
			}

	SaveConfig();
}

defaultproperties
{

}
